[Accessibility] Ensures that the heading, anchor and button elements have content in it

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<h1 class="size-1"></h1>
~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a href="#" [routerLink]="['route1']"></a>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button></button>
~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button [ariaLabelledBy]="label"></button>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<h1>Heading Content!</h1>
<h2><app-content></app-content></h2>
<h3 [innerHtml]="dangerouslySetHTML"></h3>
<h4 [innerText]="text"></h4>
<a>Anchor Content!</a>
<a><app-content></app-content></a>
<a [innerHTML]="dangerouslySetHTML"></a>
<a [innerText]="text"></a>
<a [outerHTML]="text"></a>
<a aria-hidden></a>
<button [attr.aria-hidden]="true"></button>
<h5 [attr.aria-label]="text"></h5>
<h6 title="text"></h6>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button appTooltipLabel="directive adds aria-label"></button>
<button [appTooltipLabel]="label"></button>
<h1 ariaLabel="Important Content"></h1>
<a [ariaLabel]="label"></a>
```

</details>
