Ensures that async pipe results, as well as values used with the async pipe, are not negated

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Rationale

Angular's async pipes emit null initially, prior to the observable emitting any values, or the promise resolving. This can cause negations, like \*ngIf="!(myConditional | async)" to thrash the layout and cause expensive side-effects like firing off XHR requests for a component which should not be shown.

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
{{      !(foo | async) }}
        ~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ !(foo | somethingElse | async) }}
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngIf="!(a | async)"></div>
            ~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ nullable ?? !(obsVar | async) }}
               ~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<button [disabled]="!buttonDisabled$ | async">Click me!</button>
                    ~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
{{ (foo | async) }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ !(foo | async | somethingElse) }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ (foo | async) == null }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ (foo | async) === false }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ !(foo | notAnAsyncPipe) }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div [class.mx-4]="!!(foo | async)"></div>
```

</details>
