Require explicit accessibility modifiers on class properties and methods.


TypeScript allows placing explicit `public`, `protected`, and `private` accessibility modifiers in front of class members.
The modifiers exist solely in the type system and just server to describe who is allowed to access those members.

Leaving off accessibility modifiers makes for less code to read and write.
Members are `public` by default.

However, adding in explicit accessibility modifiers can be helpful in codebases with many classes for enforcing proper privacy of members.
Some developers also find it preferable for code readability to keep member publicity explicit.

## Examples

This rule aims to make code more readable and explicit about who can use
which properties.

## When Not To Use It

If you think defaulting to public is a good default, then you should consider using the `no-public` setting. If you want to mix implicit and explicit public members then disable this rule.

## Further Reading

- TypeScript [Accessibility Modifiers Handbook Docs](https://www.typescriptlang.org/docs/handbook/2/classes.html#member-visibility)
