A visual indented line has the same indentation as the next logical line. This can make it hard to read.

### Anti-pattern

In this example the second line is indented at the same level as the body of the `if` statement.

```python
if (row < 0 or module_count <= row or
    col < 0 or module_count <= col):
    raise Exception("%s,%s - %s" % (row, col, self.moduleCount))
```

### Best practice

```python
if (row < 0 or module_count <= row or
        col < 0 or module_count <= col):
    raise Exception("%s,%s - %s" % (row, col, self.moduleCount))
```
