`NotImplemented` is a special value which should be returned by the binary special methods to indicate that the operation is not implemented with respect to the other type. Raise `NotImplementedError` to indicate that a super-class method is not implemented and that child classes should implement it.

### Anti-pattern

```python
class BaseClass:
    def abstract_method(self):
        raise NotImplemented
```

### Best practice

```python
class BaseClass:
    def abstract_method(self):
        raise NotImplementedError
```
