Makes sure that all pods have resource limits and requests set. The option `Disable CPU limit check` in the analysis profile can be set to disable the requirement of having a CPU limit.

# Details
The `request` value determines the amount of resources the container or pod is guaranteed to get.
The scheduler will only mount the pod or container on a node that can provide the required resources.
Setting the requests correctly avoids the threat of container throttling due to the lack of resources.

The `limit` value determines the maximum of resources the container or pod can claim.
Specifying limits prevents resource hogging by misbehaving containers and thus, hinders `Denial of Service` attacks through this application.
Further, it serves the scheduler as a metric to choose the best suited node for the current pod.
Limits can be set for memory and CPU as resources.
If a container exceeds its CPU limit, Kubernetes starts throttling the container because CPU is considered a compressible resource.
This can result in a worse performance, but does not cause the pod to terminate.
Memory cannot be artificially compressed in any way leading to a termination of the pod if an internal container exceeds its memory limit.

# Further Reading:
- Jim Bugwadia. 10 Kubernetes Best Practices You Can Easily Apply to Your Clusters. Nov. 14, 2019. url: https://thenewstack.io/10-kubernetes-best-practices-you-can-easily-apply-to-your-clusters/
- Brendan Burns et al. Kubernetes Best Practices. First Edition. Sebastopol: O’Reilly Media, Inc., 2019. isbn: 9781492056478.
- Sandeep Dinesh. Kubernetes best practices: Resource requests and limits. May 11, 2018. url: https://cloud.google.com/blog/products/gcp/kubernetes-best-practices-resource-requests-and-limits
- Hasham Haider. Kubernetes Production Readiness and Best Practices Checklist. replex, 2019.
- Daniele Polencic. Kubernetes production best practices. A curated checklist of best practices designed to help you release to production. url: https://learnk8s.io/production-best-practices#application-development