<h2>Why is this an issue?</h2>
<p>For clarity, all overloads of the same method should be grouped together. That lets both users and maintainers quickly understand all the current
available options.</p>
<h3>Noncompliant code example</h3>
<pre>
interface IMyInterface
{
  int DoTheThing(); // Noncompliant - overloaded method declarations are not grouped together
  string DoTheOtherThing();
  int DoTheThing(string s);
}
</pre>
<h3>Compliant solution</h3>
<pre>
interface IMyInterface
{
  int DoTheThing();
  int DoTheThing(string s);
  string DoTheOtherThing();
}
</pre>
<h3>Exceptions</h3>
<p>As it is common practice to group method declarations by implemented interface, no issue will be raised for implicit and explicit interface
implementations if grouped together with other members of that interface.</p>
<p>As it is also a common practice to group method declarations by accessibility level, no issue will be raised for method overloads having different
access modifiers.</p>
<p>Example:</p>
<pre>
class MyClass
{
  private void DoTheThing(string s) // Ok - this method is declared as private while the other one is public
  {
    // ...
  }

  private string DoTheOtherThing(string s)
  {
    // ...
  }

  public void DoTheThing()
  {
    // ...
  }
}
</pre>

