<h2>Why is this an issue?</h2>
<p>There’s no need to null test in conjunction with an <code>is</code> test. <code>null</code> is not an instance of anything, so a null check is
redundant.</p>
<h3>Noncompliant code example</h3>
<pre>
if (x != null &amp;&amp; x is MyClass) { ... }  // Noncompliant

if (x == null || !(x is MyClass)) { ... } // Noncompliant
</pre>
<h3>Compliant solution</h3>
<pre>
if (x is MyClass) { ... }

if (!(x is MyClass)) { ... }
</pre>

