<h2>Why is this an issue?</h2>
<p>When creating a custom <a href="https://learn.microsoft.com/en-us/dotnet/desktop/wpf/advanced/markup-extensions-and-wpf-xaml">Markup Extension</a>
that accepts parameters in WPF, the <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.constructorargumentattribute"><code>ConstructorArgument</code></a> markup
must be used to identify the discrete properties that match these parameters. However since this is done via a string, the compiler won’t give you any
warning in case there are typos.</p>
<p>This rule raises an issue when the string argument to <code>ConstructorArgumentAttribute</code> doesn’t match any parameter of any constructor.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
using System;

namespace MyLibrary
{
  public class MyExtension : MarkupExtension
  {
    public MyExtension() { }

    public MyExtension(object value1)
    {
      Value1 = value1;
    }

    [ConstructorArgument("value2")]   // Noncompliant
    public object Value1 { get; set; }
  }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
using System;

namespace MyLibrary
{
  public class MyExtension : MarkupExtension
  {
    public MyExtension() { }

    public MyExtension(object value1)
    {
      Value1 = value1;
    }

    [ConstructorArgument("value1")]
    public object Value1 { get; set; }
  }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/desktop/wpf/advanced/markup-extensions-and-wpf-xaml">Markup Extensions and
  WPF XAML</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.markupextension">MarkupExtension Class</a> </li>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/api/system.windows.markup.constructorargumentattribute">ConstructorArgumentAttribute Class</a> </li>
</ul>

