﻿## SA1011

<table>
<tr>
  <td>TypeName</td>
  <td>SA1011ClosingSquareBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1011</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A closing square bracket within a C# statement is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a closing square bracket is not correct.

A closing square bracket should never be preceded by whitespace, unless it is the first character on the line.

A closing square bracket should be followed by whitespace unless:
* It is the last character on the line
* It is followed by a closing bracket or an opening parenthesis
* It is followed by a comma or semicolon
* It is followed by a string interpolation alignment component. For example: `$"{x[i]:C}"`
* It is followed by a string interpolation formatting component. For example: `$"{x[i],3}"`
* It is followed by certain types of operator symbols.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the closing square bracket follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1011:ClosingSquareBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1011 // ClosingSquareBracketsMustBeSpacedCorrectly
#pragma warning restore SA1011 // ClosingSquareBracketsMustBeSpacedCorrectly
```
