## SA1142

<table>
<tr>
  <td>TypeName</td>
  <td>SA1142ReferToTupleElementsByName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1142</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.
:memo: This rule is only active for C# 7.0 and higher

## Cause

An element of a tuple was referenced by its metadata name when an element name is available.

## Rule description

An element of a tuple was referenced by its metadata name when an element name is available.  See the documentation on [tuple types](https://docs.microsoft.com/en-us/dotnet/csharp/tuples) for information on how to work with tuples in C# 7.

For example, the following code would produce a violation of this rule:

```csharp
(int valueA, int valueB) x;

var y = x.Item1; // SA1142
```

The following code would not produce any violations:

```csharp
(int valueA, int valueB) x;

var y = x.valueA;
```

## How to fix violations

To fix a violation of this rule, use the appropriate tuple element name in code instead of the metadata name.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1142:ReferToTupleElementsByName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1142 // Refer to tuple elements by name
#pragma warning restore SA1142 // Refer to tuple elements by name
```
