﻿## SA1303

<table>
<tr>
  <td>TypeName</td>
  <td>SA1303ConstFieldNamesMustBeginWithUpperCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1303</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

The name of a constant C# field should begin with an upper-case letter.

## Rule description

A violation of this rule occurs when the name of a field marked with the *const* attribute does not begin with an upper-case letter.

If the field or variable name is intended to match the name of an item associated with Win32 or COM, and thus needs to begin with a lower-case letter, place the field or variable within a special *NativeMethods* class. A NativeMethods class is any class which contains a name ending in NativeMethods, and is intended as a placeholder for Win32 or COM wrappers. StyleCop will ignore this violation if the item is placed within a NativeMethods class.

## How to fix violations

To fix a violation of this rule, change the name of the constant field so that it begins with an upper-case letter, or place the item within a NativeMethods class if appropriate.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1303:ConstFieldNamesMustBeginWithUpperCaseLetter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1303 // ConstFieldNamesMustBeginWithUpperCaseLetter
#pragma warning restore SA1303 // ConstFieldNamesMustBeginWithUpperCaseLetter
```
