﻿## SA1306

<table>
<tr>
  <td>TypeName</td>
  <td>SA1306FieldNamesMustBeginWithLowerCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1306</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

The name of a field in C# does not begin with a lower-case letter.

## Rule description

A violation of this rule occurs when the name of a field begins with an upper-case letter. Constants, non-private
readonly fields and static readonly fields should always start with an uppercase letter, whilst private readonly fields
should start with a lowercase letter. Also, public or internal fields should always start with an uppercase letter.

If the field name is intended to match the name of an item associated with Win32 or COM, and thus needs to begin with an
upper-case letter, place the field within a special `NativeMethods` class. A `NativeMethods` class is any class which
contains a name ending in `NativeMethods`, and is intended as a placeholder for Win32 or COM wrappers. StyleCop will
ignore this violation if the item is placed within a `NativeMethods` class.

> :warning: This rule deviates from the corresponding rule in StyleCop "classic" in the following way:
>
> This rule only checks the names of fields. SA1306 in StyleCop "classic" checks fields, parameters, and local
> variables.

## How to fix violations

To fix a violation of this rule, change the name of the field so that it begins with a lower-case letter, or place the
item within a `NativeMethods` class if appropriate.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1306:FieldNamesMustBeginWithLowerCaseLetter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1306 // FieldNamesMustBeginWithLowerCaseLetter
private int Field = 3;
#pragma warning restore SA1306 // FieldNamesMustBeginWithLowerCaseLetter
```
