﻿## SA1314

<table>
<tr>
  <td>TypeName</td>
  <td>SA1314TypeParameterNamesMustBeginWithT</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1314</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The name of a C# type parameter does not begin with the capital letter T.

## Rule description

A violation of this rule occurs when the name of a C# type parameter does not begin with the capital letter T. Type parameter names should always begin with T. For example, *T* or *TKey*.

## How to fix violations

To fix a violation of this rule, add the capital letter T to the front of the type parameter name.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1314:TypeParameterNamesMustBeginWithT", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1314 // Type parameter names should begin with T
#pragma warning restore SA1314 // Type parameter names should begin with T
```
