﻿## SA1403

<table>
<tr>
  <td>TypeName</td>
  <td>SA1403FileMayOnlyContainASingleNamespace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1403</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A C# code file contains more than one namespace.

## Rule description

A violation of this rule occurs when a C# file contains more than one namespace. To increase long-term maintainability of the code-base, each file should contain at most one namespace.

## How to fix violations

To fix a violation of this rule, ensure that the file only contains a single namespace.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1403:FileMayOnlyContainASingleNamespace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1403 // FileMayOnlyContainASingleNamespace
#pragma warning restore SA1403 // FileMayOnlyContainASingleNamespace
```
