﻿## SA1619

<table>
<tr>
  <td>TypeName</td>
  <td>SA1619GenericTypeParametersMustBeDocumentedPartialClass</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1619</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A generic, partial C# element is missing documentation for one or more of its generic type parameters, and the documentation for the element contains a `<summary>` tag.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when a generic, partial element is missing documentation for one or more of its generic type parameters, and the documentation for the element contains a `<summary>` tag rather than a `<content>` tag.

When documentation is provided on more than one part of the partial class, the documentation for the two classes may be merged together to form a single source of documentation. For example, consider the following two parts of a partial class:

```csharp
/// <summary>
/// Documentation for the first part of Class1.
/// </summary>
public partial class Class1
{
}

/// <summary>
/// Documentation for the second part of Class1.
/// </summary>
public partial class Class1
{
}
```

These two different parts of the same partial class each provide different documentation for the class. When the documentation for this class is built into an SDK, the tool building the documentation will either choose to use only one part of the documentation for the class and ignore the other parts, or, in some cases, it may merge the two sources of documentation together, to form a string like: "Documentation for the first part of Class1. Documentation for the second part of Class1."

For these reasons, it can be problematic to provide SDK documentation on more than one part of the partial class. However, it is still advisable to document each part of the class, to increase the readability and maintainability of the code, and StyleCop will require that each part of the class contain header documentation.

This problem is solved through the use of the `<content>` tag, which can replace the `<summary>` tag for partial classes. The recommended practice for documenting partial classes is to provide the official SDK documentation for the class on the main part of the partial class. This documentation should be written using the standard `<summary>` tag. All other parts of the partial class should omit the `<summary>` tag completely, and replace it with a `<content>` tag. This allows the developer to document all parts of the partial class while still centralizing all of the official SDK documentation for the class onto one part of the class. The `<content>` tags will be ignored by the SDK documentation tools.

When a generic element contains a `<summary>` tag within its documentation header, StyleCop assumes that this is the main part of the class, and requires the header to contain `<typeparam>` tags for each of the generic type parameters on the class. However, if the documentation header for the class contains a `<content>` tag rather than a `<summary>` tag, StyleCop will assume that the generic type parameters are defined on another part of the class, and will not require `<typeparam>` tags on this part of the class.

## How to fix violations

To fix a violation of this rule, add or fill-in documentation text within a `<typeparam>` tag for each generic type parameter on the element, or change the `<summary>` tag to a `<content>` tag if this is not the main part of the partial class.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// A sample generic class.
/// </summary>
/// <typeparam name="S">The first generic type parameter.</typeparam>
/// <typeparam name="T">The second generic type parameter.</typeparam>
public class Class1<S, T>
{ 
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1619:GenericTypeParametersMustBeDocumentedPartialClass", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1619 // GenericTypeParametersMustBeDocumentedPartialClass
#pragma warning restore SA1619 // GenericTypeParametersMustBeDocumentedPartialClass
```
