﻿## SA1631

<table>
<tr>
  <td>TypeName</td>
  <td>SA1631DocumentationMustMeetCharacterPercentage</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1631</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A section of the Xml header documentation for a C# element does not contain enough alphabetic characters.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when part of the documentation does contain enough characters. This rule is calculated by counting the number of alphabetic characters and numbers within the documentation text, and comparing it against the number of symbols and other non-alphabetic characters. If the percentage of non-alphabetic characters is too high, this generally indicates poorly formatted documentation which will be difficult to read. For example, consider the follow summary documentation:

```csharp
/// <summary>
/// @)$(*A name--------
/// </summary>
public class Name
{
    ...
}
```

## How to fix violations

To fix a violation of this rule, rewrite the documentation text using grammatically proper language, and ensure that the ratio of symbols versus characters in the text is not too great.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1631:DocumentationMustMeetCharacterPercentage", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1631 // DocumentationMustMeetCharacterPercentage
#pragma warning restore SA1631 // DocumentationMustMeetCharacterPercentage
```
