<h2>Why is this an issue?</h2>
<p>Whenever there are portions of code that are duplicated and do not depend on the state of their container class, they can be centralized inside a
"utility class". A utility class is a class that only has static members, hence it should not be instantiated.</p>
<h3>Exceptions</h3>
<p>When a class contains <code>public static void main(String[] args)</code> method it is not considered as a utility class and will be ignored by
this rule.</p>
<h2>How to fix it</h2>
<p>To prevent the class from being instantiated, you should define a non-public constructor. This will prevent the compiler from implicitly generating
a public parameterless constructor.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class StringUtils { // Noncompliant

  public static String concatenate(String s1, String s2) {
    return s1 + s2;
  }

}
```
<h4>Compliant solution</h4>

```java
class StringUtils { // Compliant

  private StringUtils() {
    throw new IllegalStateException("Utility class");
  }

  public static String concatenate(String s1, String s2) {
    return s1 + s2;
  }

}
```