<h2>Why is this an issue?</h2>
<p>Shared naming conventions improve readability and allow teams to collaborate efficiently. This rule checks that all package names match a provided
regular expression.</p>
<h2>How to fix it</h2>
<p>Rename packages with the expected naming convention</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default regular expression <code>^[a-z_]+(\.[a-z_][a-z0-9_]*)*$</code>:</p>

```java
package org.exAmple; // Noncompliant
```
<h4>Compliant solution</h4>

```java
package org.example;
```