<h2>Why is this an issue?</h2>
<p>Integer literals starting with a zero are octal rather than decimal values. While using octal values is fully supported, most developers do not
have experience with them. They may not recognize octal values as such, mistaking them instead for decimal values.</p>
<h3>Noncompliant code example</h3>

```java
int myNumber = 010; // Noncompliant. myNumber will hold 8, not 10 - was this really expected?
```
<h3>Compliant solution</h3>

```java
int myNumber = 8;
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/atYxBQ">CERT, DCL18-C.</a> - Do not begin integer constants with 0 when specifying a decimal
  value </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/7DZGBQ">CERT, DCL50-J.</a> - Use visually distinct identifiers </li>
</ul>