<h2>Why is this an issue?</h2>
<p>A loop with at most one iteration is equivalent to an <code>if</code> statement. This can confuse developers and make the code less readable since
loops are not meant to replace <code>if</code> statements.</p>
<p>If the intention was to conditionally execute the block only once, an <code>if</code> statement should be used instead. Otherwise, the loop should
be fixed so the loop block can be executed multiple times.</p>
<p>A loop statement with at most one iteration can happen when a statement that unconditionally transfers control, such as a jump or throw statement,
is misplaced inside the loop block.</p>
<p>This rule arises when the following statements are misplaced:</p>
<ul>
  <li> <code>break</code> </li>
  <li> <code>return</code> </li>
  <li> <code>throw</code> </li>
</ul>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
int i = 0;
while(i < 10) { // Noncompliant; loop only executes once
  System.out.println("i is " + i);
  i++;
  break;
}
```

```java
for (int i = 0; i < 10; i++) { // Noncompliant; loop only executes once
  if (i == x) {
    break;
  } else {
    System.out.println("i is " + i);
    return;
  }
}
```
<h4>Compliant solution</h4>

```java
int i = 0;
while (i < 10) {
  System.out.println("i is " + i);
  i++;
}
```

```java
for (int i = 0; i < 10; i++) {
  if (i == x) {
    break;
  } else {
    System.out.println("i is " + i);
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/nutsandbolts/for.html">Oracle - The for Statement</a> </li>
</ul>