<h2>Why is this an issue?</h2>
<p>The <code>BigDecimal</code> is used to represents immutable, arbitrary-precision signed decimal numbers.</p>
<p>Differently from the <code>BigDecimal</code>, the <code>double</code> primitive type and the <code>Double</code> type have limited precision due to
the use of double-precision 64-bit IEEE 754 floating point. Because of floating point imprecision, the <code>BigDecimal(double)</code> constructor can
be somewhat unpredictable.</p>
<p>For example writing <code>new BigDecimal(0.1)</code> doesn’t create a BigDecimal which is exactly equal to 0.1, but it is equal to
0.1000000000000000055511151231257827021181583404541015625. This is because 0.1 cannot be represented exactly as a double (or, for that matter, as a
binary fraction of any finite length).</p>
<h2>How to fix it</h2>
<p>Use <code>BigDecimal.valueOf</code>, which uses a string under the covers to eliminate floating point rounding errors, or the constructor that
takes a <code>String</code> argument.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
double d = 1.1;

BigDecimal bd1 = new BigDecimal(d);   // Noncompliant
BigDecimal bd2 = new BigDecimal(1.1); // Noncompliant
```
<h4>Compliant solution</h4>

```java
double d = 1.1;

BigDecimal bd1 = BigDecimal.valueOf(d); // Compliant
BigDecimal bd2 = new BigDecimal("1.1"); // Compliant
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/math/BigDecimal.html">Oracle - BigDecimal</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/kzdGBQ">CERT, NUM10-J</a> - Do not construct BigDecimal objects from floating-point literals
  </li>
</ul>