<h2>Why is this an issue?</h2>
<p>Double-checked locking can be used for lazy initialization of <code>volatile</code> fields, but only if field assignment is the last step in the
<code>synchronized</code> block. Otherwise you run the risk of threads accessing a half-initialized object.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {

  private volatile List<String> strings;

  public List<String> getStrings() {
    if (strings == null) {  // check#1
      synchronized(MyClass.class) {
        if (strings == null) {
          strings = new ArrayList<>();  // Noncompliant
          strings.add("Hello");  //When threadA gets here, threadB can skip the synchronized block because check#1 is false
          strings.add("World");
        }
      }
    }
    return strings;
  }
}
```
<h3>Compliant solution</h3>

```java
public class MyClass {

  private volatile List<String> strings;

  public List<String> getStrings() {
    if (strings == null) {  // check#1
      synchronized(MyClass.class) {
        if (strings == null) {
          List<String> tmpList = new ArrayList<>();
          tmpList.add("Hello");
          tmpList.add("World");
          strings = tmpList;
        }
      }
    }
    return strings;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/6zdGBQ">CERT, LCK10-J.</a> - Use a correct form of the double-checked locking idiom </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S2168'>java:S2168</a> - Double-checked locking should not be used </li>
</ul>