<h2>Why is this an issue?</h2>
<p>In Java 16 records represent a brief notation for immutable data structures. Records have autogenerated implementations for constructors with all
parameters, <code>getters</code>, <code>equals</code>, <code>hashcode</code> and <code>toString</code>. Although these methods can still be overridden
inside records, there is no use to do so if no special logic is required.</p>
<p>This rule reports an issue on empty compact constructors, trivial canonical constructors and simple getter methods with no additional logic.</p>
<h3>Noncompliant code example</h3>

```java
record Person(String name, int age) {
  Person(String name, int age) { // Noncompliant, already autogenerated
    this.name = name;
    this.age = age;
  }
}

record Person(String name, int age) {
  Person { // Noncompliant, no need for empty compact constructor
  }
  public String name() { // Noncompliant, already autogenerated
    return name;
  }
}
```
<h3>Compliant solution</h3>

```java
record Person(String name, int age) { } // Compliant

record Person(String name, int age) {
  Person(String name, int age) { // Compliant
    this.name = name.toLowerCase(Locale.ROOT);
    this.age = age;
  }
}

record Person(String name, int age) {
  Person { // Compliant
    if (age < 0) {
      throw new IllegalArgumentException("Negative age");
    }
  }
  public String name() { // Compliant
    return name.toUpperCase(Locale.ROOT);
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se16/html/jls-8.html#jls-8.10">Records specification</a> </li>
</ul>