<h2>Why is this an issue?</h2>
<p>Character classes in regular expressions are a convenient way to match one of several possible characters by listing the allowed characters or
ranges of characters. If a character class contains only one character, the effect is the same as just writing the character without a character
class.</p>
<p>Thus, having only one character in a character class is usually a simple oversight that remained after removing other characters of the class.</p>
<h3>Noncompliant code example</h3>

```java
"a[b]c"
"[\\^]"
```
<h3>Compliant solution</h3>

```java
"abc"
"\\^"
"a[*]c" // Compliant, see Exceptions
```
<h3>Exceptions</h3>
<p>This rule does not raise when the character inside the class is a metacharacter. This notation is sometimes used to avoid escaping (e.g.,
<code>[.]{3}</code> to match three dots).</p>