<h2>Why is this an issue?</h2>
<p>JavaScript allows duplicate property names in classes and object literals. The last occurrence will overwrite previous definitions. Therefore,
having more than one occurrence will have no effect and may cause misunderstandings and bugs.</p>

```js
let data = {
  "key": "value",
  "1": "value",
  "key": "value", // Noncompliant - duplicate of "key"
  'key': "value", // Noncompliant - duplicate of "key"
  key: "value", // Noncompliant - duplicate of "key"
  \u006bey: "value", // Noncompliant - duplicate of "key"
  "\u006bey": "value", // Noncompliant - duplicate of "key"
  "\x6bey": "value", // Noncompliant - duplicate of "key"
  1: "value" // Noncompliant - duplicate of "1"
}

class Foo {
  bar() { }
  bar() { }  // Noncompliant - duplicate of "bar"
}
```
<p>Defining a <code>class</code> with a duplicated <code>constructor</code> will generate an error.</p>

```js
class Class {
  constructor() {
  }
  constructor(value) { // Noncompliant: A class may only have one constructor
  }
}
```
<p>Before ECMAScript 2015, using duplicate names generated an error in JavaScript strict mode code.</p>
<p>This rule will also report on duplicate properties in JSX.</p>

```js
function MyComponent(props) {
  return <div prop={props.prop1} prop={props.prop2}> { /* Noncompliant, 'prop' is defined twice */ }
    This is my component
  </div>;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Object_initializer#property_definitions">Property definitions</a>
  </li>
</ul>