<h2>Why is this an issue?</h2>
<p>Arrow functions in JavaScript provide a concise syntax to write function expressions. However, the use of braces <code>{}</code> and parentheses
<code>()</code> should be consistent in arrow functions for the following reasons:</p>
<ul>
  <li> Readability: Consistent use of braces and parentheses improves the readability of the code. It makes it easier for other developers to
  understand the code quickly and reduces the chances of misinterpretation. </li>
  <li> Predictability: When braces and parentheses are used consistently, it makes the code more predictable. Developers can easily predict the
  outcome of the function. </li>
  <li> Avoid Errors: Inconsistent use of braces and parentheses can lead to errors. For example, if braces are omitted for a function that has more
  than one statement, it will result in a syntax error. </li>
  <li> Code Maintenance: Consistent use of braces and parentheses makes the code easier to maintain. It’s easier to add or remove code lines without
  worrying about adjusting braces or parentheses. </li>
</ul>
<p>Shared coding conventions allow teams to collaborate effectively. This rule raises an issue when using parentheses and curly braces with an arrow
function does not conform to the configured requirements.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<p>Use parentheses and curly braces with arrow functions consistently. By default, the rule forbids arrow functions to have parentheses around single
parameters and curly braces around single-return bodies.</p>
<h4>Noncompliant code example</h4>

```js
const foo = (a) => { /* ... */ };  // Noncompliant; remove the parentheses from the parameter
const bar = (a, b) => { return 0; };  // Noncompliant; remove the curly braces from the body
```
<h4>Compliant solution</h4>

```js
const foo = a => { /* ... */ };
const bar = (a, b) => 0;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Arrow_functions">Arrow function
  expressions</a> </li>
</ul>