<p>This rule raises an issue when a function call result is used, even though the function does not return anything.</p>
<h2>Why is this an issue?</h2>
<p>When a function in JavaScript does not have a return statement or if it has a return statement without a value, it implicitly returns
<code>undefined</code>. This means that a function without a return statement or with an empty return statement is, in a way, a "void" function, as it
doesn’t return any specific value.</p>
<p>Therefore, attempting to use the return value of a void function in JavaScript is meaningless, and it can lead to unexpected behavior or
errors.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
function foo() {
  console.log("Hello, World!");
}

let a = foo(); // Noncompliant: Assigning the return value of a void function
```
<p>You should not use in any way the return value of a void function.</p>
<h4>Compliant solution</h4>

```js
function foo() {
  console.log("Hello, World!");
}

foo();
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined"><code>undefined</code>
  global property</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/return"><code>return</code> statement</a>
  </li>
</ul>