<h2>Why is this an issue?</h2>
<p>The <code>done</code> callback of Mocha is used to signal the end of an asynchronous test. It is called when the test is complete, either
successfully or with an error. It is important not to follow the <code>done</code> callback with code because the test may not have completed yet, and
the code may execute before the test is finished. This can lead to unpredictable results and make it difficult to debug issues.</p>
<p>It is recommended to use the <code>done</code> callback only to signal the end of the test and handle any necessary cleanup or assertions before
the callback.</p>
<p>Here’s a bad example of using Mocha’s <code>done</code> callback:</p>

```js
const expect = require("chai").expect;

describe('My test suite', function() {
  it('should do something asynchronously', function(done) {
    setTimeout(function() {
        expect(2 + 2).to.equal(4);
        expect('hello').to.have.lengthOf(5);
        done();

        console.log('Test has completed.'); // Noncompliant: Code after calling done, which may produce unexpected behavior
    }, 1000);
  });
});
```
<p>Since the <code>console.log</code> statement is executed after calling <code>done()</code>, there is no guarantee that it will run after the test
has fully completed. It may be correctly executed, but it might as well be assigned to a different test, no test, or even completely ignored.</p>
<p>To fix this, the <code>done</code> callback should be called after the <code>console.log</code> statement.</p>

```js
const expect = require("chai").expect;

describe('My test suite', function() {
  it('should do something asynchronously', function(done) {
    setTimeout(function() {
        expect(2 + 2).to.equal(4);
        expect('hello').to.have.lengthOf(5);

        console.log('Test has completed.');
        done();
    }, 1000);
  });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Mocha Documentation - <a href="https://mochajs.org/#asynchronous-code">Asynchronous code</a> </li>
</ul>