<h2>Why is this an issue?</h2>
<p>In JavaScript, the <code>String.prototype.replace()</code> method is used to replace parts of a string with new substrings. It allows you to
perform simple to complex string replacements based on either a static string or a regular expression pattern.</p>
<p>When the first argument is a regular expression, the method will use the regular expression to search for matches within the original string and
then replace those matches with the specified replacement. If the second argument is a string, the method will use it as the static replacement for
the matched substrings found by the regular expression.</p>
<p>Within the replacement string, the function supports special placeholders to insert the matched values of capturing groups from the regular
expression:</p>
<ul>
  <li> The <code>$n</code> syntax allows you to reference capturing groups by their numerical index. The number <code>n</code> corresponds to the
  order in which the capturing group appears in the regular expression, starting from 1 for the first capturing group. </li>
  <li> The <code>$&lt;Name&gt;</code> syntax allows you to reference capturing groups by their name. Instead of using numerical indices, you can
  assign a name to a capturing group using <code>?&lt;Name&gt;</code> within the regular expression. </li>
</ul>
<p>If the second argument of <code>String.prototype.replace()</code> references non-existing groups (capturing groups that do not exist in the regular
expression), the behavior of the replacement will depend on the specific references made. It won’t cause an error, but the replacement will not be
based on any captured values, potentially leading to unexpected results in the replaced string:</p>
<ul>
  <li> If the replacement string contains references like <code>$1</code>, <code>$2</code>, etc., to capturing groups that don’t exist in the regular
  expression, those references will be treated as literals. In other words, the <code>$n</code> will be replaced with the literal text <code>$n</code>
  itself. </li>
  <li> If the replacement string contains references like <code>$&lt;Name&gt;</code>, they will also be treated as literals, but only if there are no
  named captures in the regular expression; otherwise, they will be replaced with the empty string. </li>
</ul>
<p>This rule checks that all referenced groups exist when replacing a pattern with a replacement string using <code>String.prototype.replace()</code>
or <code>String.prototype.replaceAll()</code> methods.</p>

```js
const str = 'John Doe';
console.log(str.replace(/(\w+)\s(\w+)/, '$1, $0 $1')); // Noncompliant: index is 1-based, '$0' does not exist, prints 'John, $0 John'
console.log(str.replace(/(?<firstName>\w+)\s(?<lastName>\w+)/, '$<surname>, $<firstName> $<surname>')); // Noncompliant: '$<surname>' does not exist but there are named captures, prints ', John '
```
<p>Always check your regular expression and replacement string to ensure they properly reference existing capturing groups, most specifically, the
latter references capturing groups existing in the former.</p>

```js
const str = 'John Doe';
console.log(str.replace(/(\w+)\s(\w+)/, '$2, $1 $2'));
console.log(str.replace(/(?<firstName>\w+)\s(?<lastName>\w+)/, '$<lastName>, $<firstName> $<lastName>'));
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace"><code>String.prototype.replace()</code></a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replaceAll"><code>String.prototype.replaceAll()</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions">Regular expressions</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Regular_expressions/Capturing_group">Capturing group:
  <code>(...)</code></a> </li>
</ul>