<h2>Why is this an issue?</h2>
<p>The <code>Object.hasOwn()</code> method was introduced in ES2022 as a replacement for the more verbose
<code>Object.prototype.hasOwnProperty.call()</code>. These methods return <code>true</code> if the specified property of an object exists as its
<em>own</em> property. If the property is only available further down the prototype chain or does not exist at all - the methods return
<code>false</code>.</p>
<p>If you are still using the old method - replace it with a simpler and more concise alternative.</p>
<p>You should also avoid calling the <code>obj.hasOwnProperty()</code> method directly, without using <code>Object.prototype</code> as a source. This
can lead to a runtime error if <code>obj.prototype</code> is <code>null</code> and therefore <code>obj.hasOwnProperty</code> is undefined. The static
method <code>Object.hasOwn()</code> does not depend on the <code>obj.prototype</code> and is therefore safe to use in such cases.</p>

```js
Object.prototype.hasOwnProperty.call(obj, "propertyName"); // Noncompliant
Object.hasOwnProperty.call(obj, "propertyName"); // Noncompliant
({}).hasOwnProperty.call(obj, "propertyName"); // Noncompliant
```
<p>To fix the code replace <code>hasOwnProperty()</code> with <code>Object.hasOwn()</code></p>

```js
Object.hasOwn(obj, "propertyName");
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwn">Object.hasOwn()</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwnProperty">Object.prototype.hasOwnProperty()</a>
  </li>
</ul>