<h2>Why is this an issue?</h2>
<p>React has a special prop called <code>dangerouslySetInnerHTML</code> that allows you to assign a raw HTML string to the underlying DOM
<code>innerHTML</code> property. Changing <code>innerHTML</code> will replace the element’s child nodes or text content. For this reason,
<code>dangerouslySetInnerHTML</code> should never be used together with component <code>children</code> as they will conflict with each other, both
trying to set the inner content of the same element.</p>

```js
function MyComponent() {
    return ( // Noncompliant: don't use children and dangerouslySetInnerHTML at the same time
        <div dangerouslySetInnerHTML={{ __html: "HTML" }}>
            Children
        </div>
    );
}
```
<p>To fix the issue leave either the element’s <code>children</code> or <code>dangerouslySetInnerHTML</code>, but not both.</p>

```js
function MyComponent() {
    return (
        <div dangerouslySetInnerHTML={{ __html: "HTML" }} />
    );
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component#passing-jsx-as-children">Passing JSX as children</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react-dom/components/common#dangerously-setting-the-inner-html">Dangerously setting
  the inner HTML</a> </li>
</ul>