<p>A <code>&lt;label&gt;</code> element should wrap a control element or have an <code>&lt;htmlFor&gt;</code> attribute referencing a control and text
content.</p>
<h2>Why is this an issue?</h2>
<p>When a label element lacks a text label or an associated control, it can lead to several issues:</p>
<ol>
  <li> <strong>Poor Accessibility</strong>: Screen readers rely on correctly associated labels to describe the function of the form control. If the
  label is not properly associated with a control, it can make the form difficult or impossible for visually impaired users to understand or interact
  with. </li>
  <li> <strong>Confusing User Interface</strong>: Labels provide users with clear instructions about what information is required in a form control.
  Without a properly associated label, users might not understand what input is expected, leading to confusion and potential misuse of the form. </li>
  <li> <strong>Code Maintainability</strong>: Properly structured and labeled code is easier to read, understand, and maintain. When labels are not
  correctly associated, it can make the code more difficult to navigate and debug, especially for new developers or those unfamiliar with the
  codebase. </li>
</ol>
<p>Control elements are: * <code>&lt;input&gt;</code> * <code>&lt;meter&gt;</code> * <code>&lt;output&gt;</code> * <code>&lt;progress&gt;</code> *
<code>&lt;select&gt;</code> * <code>&lt;textarea&gt;</code></p>
<h3>Exceptions</h3>
<p>Custom components may contain control elements, therefore label elements containing custom elements do not raise issues.</p>
<h2>How to fix it</h2>
<p>If you have a pair of control and <code>&lt;label&gt;</code> elements, make sure that the <code>&lt;label&gt;</code> wraps the control element. If
you lack a control element, add one.</p>
<p>It is strongly recommended to avoid using generated <code>id</code>s since they must be deterministic.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
<input type="text" />
<label>Favorite food</label>
```
<h4>Compliant solution</h4>

```js
<label>
  <input type="text" />
  Favorite food
</label>
```
<h4>Noncompliant code example</h4>

```js
<label>Favorite food</label>
```
<h4>Compliant solution</h4>

```js
<label>
  <MyCustomInput />
  Favorite food
</label>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label">The Label element</a> </li>
  <li> W3C - <a href="https://www.w3.org/WAI/WCAG21/Understanding/info-and-relationships">Info and Relationships</a> </li>
  <li> W3C - <a href="https://www.w3.org/WAI/WCAG21/Understanding/labels-or-instructions">Labels or Instructions</a> </li>
</ul>