<h2>Why is this an issue?</h2>
<p>The expression can be simplified using one of the functions <code>isEmpty</code>, <code>isNotEmpty</code> or <code>isNullOrEmpty</code>.</p>
<h3>What is the potential impact?</h3>
<h4>Readability and Understanding</h4>
<p>This change makes the code more concise and easier to understand. The additional comparison operator would increase the complexity of the
expression while not offering any benefit. The function names <code>isEmpty</code>, <code>isNotEmpty</code> and <code>isNullOrEmpty</code> are
descriptive on the other hand, so it is evident to readers what the purpose of the expression is.</p>
<h2>How to fix it</h2>
<p>Replace</p>
<ul>
  <li> <code>collection.size == 0</code>, <code>collection.count() == 0</code> or <code>!collection.isNotEmpty()</code> with
  <code>collection.isEmpty()</code> </li>
  <li> <code>collection.size != 0</code>, <code>collection.count() != 0</code> or <code>!collection.isEmpty()</code> with
  <code>collection.isNotEmpty()</code> </li>
  <li> <code>collection == null || collection.size == 0</code> or <code>collection == null || collection.count() == 0</code> with
  <code>collection.isNullOrEmpty()</code> </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```kotlin
val list = listOf(5,2,9,6,8,2,5,7,3)
```

```kotlin
val hasElemenents = !list.isEmpty() // Noncompliant, use isNotEmpty()
val hasNoElemenents = list.count() == 0 // Noncomplient, use isEmpty()

fun isNullOrEmpty(list: List<Int>?): Boolean = list == null || list.size == 0 // Noncompliant, use isNullOrEmpty
```
<h4>Compliant solution</h4>

```kotlin
val hasElemenents = list.isNotEmpty() // Compliant
val hasNoElemenents = list.isEmpty() // Compliant

fun isNullOrEmpty(list: List<Int>?): Boolean = list.isNullOrEmpty() // Compliant
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/">Kotlin API Docs, Package kotlin.collections</a> </li>
</ul>