<h2>Why is this an issue?</h2>
<p>The <code>switch</code> statement should be used only to clearly define some new branches in the control flow. As soon as a <code>case</code>
clause contains too many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the
<code>case</code> clause should be extracted into a dedicated method.</p>
<h3>Noncompliant code example</h3>
<p>With a threshold of 5:</p>

```php
switch ($var) {
  case 0:  // 6 lines till next case
    methodCall1();
    methodCall2();
    methodCall3();
    methodCall4();
    break;
  default:
    break;
}
```
<h3>Compliant solution</h3>

```php
switch ($var) {
  case 0:
    doSomething();
    break;
  default:
    break;
}

function doSomething(){
  methodCall1("");
  methodCall2("");
  methodCall3("");
  methodCall4("");
}
```