<h2>Why is this an issue?</h2>
<p>Putting multiple statements on a single line lowers the code readability and makes debugging the code more complex.</p>

```php
if (someCondition) doSomething(); // Noncompliant
```
<p>Write one statement per line to improve readability.</p>

```php
if (someCondition) {
  doSomething();
}
```
<h3>Exceptions</h3>
<p>The rule ignores anonymous functions containing a single statement.</p>

```php
$max_comparator = function ($v) { return $v > 2; };           // Compliant by exception
$max_comparator = function ($v) { echo $v; return $v > 2; };  // Noncompliant
```