<h2>Why is this an issue?</h2>
<p>Files that define symbols such as classes and variables may be included into many files. Simply performing that inclusion should have no effect on
those files other than declaring new symbols. For instance, a file containing a class definition should not also contain side-effects such as
<code>print</code> statements that will be evaluated automatically on inclusion. Logic should be segregated into symbol-only files and
side-effect-only files. The type of operation which is not allowed in a symbol-definition file includes but is not limited to:</p>
<ul>
  <li> generating output </li>
  <li> modifying <code>ini</code> settings </li>
  <li> emitting errors or exceptions </li>
  <li> modifying global or static variables </li>
  <li> reading/writing files </li>
</ul>
<h3>Noncompliant code example</h3>

```php
<?php

print "Include worked!";

class foo {
  // ...
}
```
<h3>Compliant solution</h3>

```php
<?php

class foo {

  public function log() {
    print "Include worked!";
  }

}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.php-fig.org/psr/psr-1/">PHP-FIG Basic Coding Standard PSR1</a>, 2.3 - Side Effects </li>
</ul>