<h2>Why is this an issue?</h2>
<p>Certain functions exist in PHP only as aliases of other functions. These aliases have been made available for backward compatibility, but should
really be removed from code.</p>
<p>This rule looks for uses of the following aliases:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Alias</th>
      <th>Replacement</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>chop</code></p></td>
      <td><p><code>rtrim</code></p></td>
    </tr>
    <tr>
      <td><p><code>close</code></p></td>
      <td><p><code>closedir</code></p></td>
    </tr>
    <tr>
      <td><p><code>doubleval</code></p></td>
      <td><p><code>floatval</code></p></td>
    </tr>
    <tr>
      <td><p><code>fputs</code></p></td>
      <td><p><code>fwrite</code></p></td>
    </tr>
    <tr>
      <td><p><code>ini_alter</code></p></td>
      <td><p><code>ini_set</code></p></td>
    </tr>
    <tr>
      <td><p><code>is_double</code></p></td>
      <td><p><code>is_float</code></p></td>
    </tr>
    <tr>
      <td><p><code>is_integer</code></p></td>
      <td><p><code>is_int</code></p></td>
    </tr>
    <tr>
      <td><p><code>is_long</code></p></td>
      <td><p><code>is_int</code></p></td>
    </tr>
    <tr>
      <td><p><code>is_real</code></p></td>
      <td><p><code>is_float</code></p></td>
    </tr>
    <tr>
      <td><p><code>is_writeable</code></p></td>
      <td><p><code>is_writable</code></p></td>
    </tr>
    <tr>
      <td><p><code>join</code></p></td>
      <td><p><code>implode</code></p></td>
    </tr>
    <tr>
      <td><p><code>key_exists</code></p></td>
      <td><p><code>array_key_exists</code></p></td>
    </tr>
    <tr>
      <td><p><code>magic_quotes_runtime</code></p></td>
      <td><p><code>set_magic_quotes_runtime</code></p></td>
    </tr>
    <tr>
      <td><p><code>pos</code></p></td>
      <td><p><code>current</code></p></td>
    </tr>
    <tr>
      <td><p><code>show_source</code></p></td>
      <td><p><code>highlight_file</code></p></td>
    </tr>
    <tr>
      <td><p><code>sizeof</code></p></td>
      <td><p><code>count</code></p></td>
    </tr>
    <tr>
      <td><p><code>strchr</code></p></td>
      <td><p><code>strstr</code></p></td>
    </tr>
  </tbody>
</table>
<h3>Noncompliant code example</h3>

```php
$arr=array("apple", "pear","banana");
echo sizeof($arr);  // Noncompliant
```
<h3>Compliant solution</h3>

```php
$arr=array("apple", "pear","banana");
echo count($arr);
```