<h2>Why is this an issue?</h2>
<p>Instead of using boolean literals or <em>null</em> in an equality with <em>assertSame()</em> or <em>assertEquals()</em>, it is recommended to rely
on the alternative functions <em>assertTrue()</em>, <em>assertFalse()</em>, assertNull(), and <em>assertNotNull()</em>.</p>
<h3>Noncompliant code example</h3>

```php
assertEquals(true, $x); // Noncompliant {{Use assertTrue() instead.}}
assertNotEquals(false, $x); // Noncompliant {{Use assertTrue() instead.}}
assertSame(null, $x); // Noncompliant {{Use assertNull() instead.}}
assertNotSame(true, $x); // Noncompliant {{Use assertFalse() instead.}}
```
<h3>Compliant solution</h3>

```php
assertTrue($x); // Compliant
assertFalse($x); // Compliant
assertNull($x); // Compliant
assertNotNull($x); // Compliant
```