<h2>Why is this an issue?</h2>
<p>JavaScript has special identifiers that, while not reserved, still should not be used as identifiers. They form the JavaScript standard built-in
objects and global properties. They are available in all environments. Some examples are:</p>
<ul>
  <li> Global objects: <code>Object</code>, <code>Function</code>, <code>Error</code>, …​ </li>
  <li> Global object function properties: <code>eval()</code>, <code>isNan()</code>, <code>parseFloat()</code>, <code>decodeURI()</code>, …​ </li>
  <li> Global object value properties: <code>undefined</code>, <code>NaN</code>, <code>Infinity</code> </li>
  <li> Identifiers with special meanings: <code>arguments</code> </li>
</ul>
<p>These words should not be bound or assigned, because doing so would overwrite the original definitions of these identifiers. What’s more, assigning
or binding some of these names will generate an error in JavaScript strict mode code.</p>
<h3>Noncompliant code example</h3>

```ts
eval = 17; // Noncompliant
arguments++; // Noncompliant
++eval; // Noncompliant
const obj = { set p(arguments) { } }; // Noncompliant
let eval; // Noncompliant
try { /* ... */ } catch (arguments) { } // Noncompliant
function x(eval) { /* ... */ } // Noncompliant
function arguments() { /* ... */ } // Noncompliant
const y = function eval() { /* ... */ }; // Noncompliant

function fun() {
  if (arguments.length == 0) { // Compliant
    // do something
  }
}
```
<h3>Compliant solution</h3>

```ts
result = 17;
args++;
++result;
const obj = { set p(arg) { } };
let result;
try { /* ... */ } catch (args) { }
function x(arg) { /* ... */ }
function args() { /* ... */ }
const y = function fun() { /* ... */ };

function fun() {
  if (arguments.length == 0) {
    // do something
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar#reserved_words">Reserved words</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar#identifiers_with_special_meanings">Identifiers with special
  meanings</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects">Global Objects</a> </li>
</ul>