<h2>Why is this an issue?</h2>
<p>Using regular expression literals is recommended over using the <code>RegExp</code> constructor calls if the pattern is a literal. Regular
expression literals are shorter, more readable, and do not need to be escaped like string literals. They can also be more performant because regular
expression literals are compiled only once when the script is loaded.</p>

```ts
new RegExp(/foo/);
new RegExp('bar');
new RegExp('baz', 'i');
new RegExp("\\d+");
new RegExp(`qux|quuz`);
```
<p>Using the <code>RegExp</code> constructor is suitable when the pattern is computed dynamically, for example, when the user provides it. Otherwise,
you should prefer the more concise syntax of regular expression literals.</p>

```ts
/foo/;
/bar/;
/baz/i;
/\d+/;
/qux|quuz/;
new RegExp(`Dear ${title},`);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions">Regular expressions</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp"><code>RegExp</code></a> </li>
</ul>