<h2>Why is this an issue?</h2>
<p><code>String.match()</code> behaves the same way as <code>RegExp.exec()</code> when the regular expression does not include the global flag
<code>g</code>. While they work the same, <code>RegExp.exec()</code> can be slightly faster than <code>String.match()</code>. Therefore, it should be
preferred for better performance.</p>
<p>The rule reports an issue on a call to <code>String.match()</code> whenever it can be replaced with semantically equivalent
<code>RegExp.exec()</code>.</p>

```ts
'foo'.match(/bar/);
```
<p>Rewrite the pattern matching from <code>string.match(regex)</code> to <code>regex.exec(string)</code>.</p>

```ts
/bar/.exec('foo');
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/fr/docs/Web/JavaScript/Reference/Global_Objects/String/match"><code>String.prototype.match()</code></a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/exec"><code>RegExp.prototype.exec()</code></a> </li>
</ul>