<p>Navigation using the Tab key should be restricted to elements on the page that users can interact with.</p>
<h2>Why is this an issue?</h2>
<p>The misuse of the <code>tabIndex</code> attribute can lead to several issues:</p>
<ul>
  <li> Navigation Confusion: It can confuse users who rely on keyboard navigation, as they might expect to tab through interactive elements like links
  and buttons, not static content. </li>
  <li> Accessibility Issues: It can create accessibility problems, as assistive technologies provide their own page navigation mechanisms based on the
  HTML of the page. Adding unnecessary tabindexes can disrupt this. </li>
  <li> Increased Tab Ring Size: It unnecessarily increases the size of the page’s tab ring, making navigation more cumbersome. </li>
</ul>
<h2>How to fix it</h2>
<p>Simply remove the <code>tabIndex</code> attribute or set it to <code>"-1"</code> to fix the issue.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<div tabIndex="0" />
```
<h4>Compliant solution</h4>

```ts
<div />
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/tabindex">tabindex</a> </li>
  <li> The a11y project - <a href="https://www.a11yproject.com/posts/how-to-use-the-tabindex-attribute/">Use the tabindex attribute</a> </li>
</ul>