/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.spi.TeamscaleServiceLoader;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.core.utils.RamUtils;
import com.teamscale.index.backup.DefaultBackupSettingsAcknowledgedOption;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.ILegacyUsageDataProvider;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.List;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/global-warnings")
public class TeamscaleGlobalWarningsService
extends ApiBase {
    @Path(value="sufficientRam")
    @GET
    @RequiresNoPermission
    @Operation(summary="Sufficient Ram", description="Checks whether Teamscale has enough RAM to operate, given the amount of workers.", tags={"System"})
    public SufficientRamResponse hasSufficientRam() {
        long ramSize = RamUtils.getRamSizeMB((String)RamUtils.getXmxArgument());
        int numberOfWorkers = this.serviceInfo.getServerConfiguration().getNumWorkers();
        boolean hasSufficientRam = EFeatureToggle.DISABLE_MEMORY_CHECK.isEnabled() || RamUtils.hasSufficientRam((int)numberOfWorkers, (long)ramSize);
        return new SufficientRamResponse(hasSufficientRam, ramSize + " MB", numberOfWorkers);
    }

    @Path(value="inMemory")
    @GET
    @RequiresNoPermission
    @Operation(summary="In Memory Database", description="Checks whether Teamscale operates on an in memory database when it shouldn't.", tags={"System"})
    public boolean showInMemoryWarning() {
        boolean testModeEnabled = EFeatureToggle.ENABLE_TEST_MODE.isEnabled();
        boolean devModeEnabled = EFeatureToggle.ENABLE_DEV_MODE.isEnabled();
        if (testModeEnabled || devModeEnabled) {
            return false;
        }
        return this.serviceInfo.getServerConfiguration().getDatabaseConfiguration().getDatabaseType() == DatabaseConfiguration.EDatabaseType.MEMORY;
    }

    @Path(value="defaultAdmin")
    @GET
    @RequiresNoPermission
    @Operation(summary="Default Admin Enabled", description="Checks whether Teamscale has the default admin user enabled when it shouldn't.", tags={"System"})
    public boolean showDefaultAdminWarning() throws StorageException {
        if (EFeatureToggle.NO_WARN_ON_UNSAFE_ADMIN_USER.isEnabled() || EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            return false;
        }
        if (!this.getPermissions().createPermissionSummary().isAdmin()) {
            return false;
        }
        return this.existsDefaultAdminUser();
    }

    private boolean existsDefaultAdminUser() throws StorageException {
        UserIndex userIndex = (UserIndex)this.openGlobalIndex(UserIndex.class);
        ServerOptionIndex optionIndex = (ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class);
        User adminUser = (User)UserUtils.wipeAfterUse((char[])"admin".toCharArray(), passwordBytes -> AuthenticationManager.getInstance().authenticate("admin", passwordBytes, userIndex, optionIndex, false));
        if (adminUser != null) {
            return this.hasAdminRights(adminUser);
        }
        return false;
    }

    private boolean hasAdminRights(User user) throws StorageException {
        SynchronizedCacheAccess permissionCacheAccess = this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class);
        PermissionIndex permissionIndex = (PermissionIndex)this.openGlobalIndex(PermissionIndex.class);
        UserGroupIndex groupIndex = (UserGroupIndex)this.openGlobalIndex(UserGroupIndex.class);
        ProjectIndex projectIndex = (ProjectIndex)this.openGlobalIndex(ProjectIndex.class);
        UserPermissionsProvider userPermissionsProvider = new UserPermissionsProvider(groupIndex, permissionIndex, permissionCacheAccess);
        return new ServicePermissions(userPermissionsProvider.getUserPermissions(user), null, projectIndex, permissionIndex).createPermissionSummary().isAdmin();
    }

    @Path(value="shadowMode")
    @GET
    @RequiresNoPermission
    @Operation(summary="Shadow Mode", description="Checks whether Teamscale has the shadow mode enabled.", tags={"System"})
    public boolean showShadowModeWarning() throws StorageException {
        return this.getPermissions().hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES) && ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.getGlobalStorageSystem());
    }

    @Path(value="defaultBackupSettings")
    @GET
    @RequiresNoPermission
    @Operation(summary="Default Backup Settings", description="Checks whether Teamscale has default backup settings enabled, which were not yet acknowledged by an admin user.\n", tags={"System"})
    public boolean showDefaultBackupSettingsWarning() throws StorageException {
        if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            return false;
        }
        return this.getPermissions().hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES) && !DefaultBackupSettingsAcknowledgedOption.areBackupSettingsAcknowledged((GlobalStorageSystem)this.getGlobalStorageSystem());
    }

    @Path(value="activeUsers")
    @GET
    @RequiresNoPermission
    @Operation(summary="Number of Active User", description="Calculates the number of active users in the past 90 days. This is either the number of active Teamscale users or the number of committers, depending on which value is larger.\n", tags={"System"})
    public int getNumberOfActiveUsers() throws StorageException {
        UserLastActivityIndex lastActivityIndex = (UserLastActivityIndex)this.openGlobalIndex(UserLastActivityIndex.class);
        List lastActivityTimestamps = lastActivityIndex.getLastActivityTimestamps();
        int numberOfActiveUsers = UsageDataCollector.calculateActiveUsers((TemporalAmount)Period.ofDays(90), (List)lastActivityTimestamps);
        int numberOfCommitters = lastActivityIndex.getNumberOfCommitters(EUserActivityPeriods.LAST_90DAYS);
        return Math.max(numberOfActiveUsers, numberOfCommitters);
    }

    @Path(value="legacy-api-usage")
    @GET
    @RequiresNoPermission
    @Operation(summary="Whether the legacy API was used since the last instance restart.", description="The legacy API will be disabled in Teamscale v10.0 and completely removed in a future version. This endpoint provides information whether the legacy API was used since the last instance restart.")
    public boolean wasLegacyApiUsed() {
        if (!this.getPermissions().createPermissionSummary().isAdmin()) {
            return false;
        }
        return ((ILegacyUsageDataProvider)TeamscaleServiceLoader.loadExactlyOne(ILegacyUsageDataProvider.class)).wasLegacyServiceUsed();
    }

    public record SufficientRamResponse(@JsonProperty(value="hasSufficientRam") boolean hasSufficientRam, @JsonProperty(value="availableMemory") String availableMemory, @JsonProperty(value="numberOfWorkers") int numberOfWorkers) {
    }
}

