/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.common.data.ObjectRes;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lru/bozaro/gitlfs/client/internal/MetaGet;", "Lru/bozaro/gitlfs/client/internal/Request;", "Lru/bozaro/gitlfs/common/data/ObjectRes;", "()V", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "statusCodes", "", "gitlfs-client"})
public final class MetaGet
implements Request<ObjectRes> {
    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpGet req = new HttpGet(url);
        req.addHeader("Accept", "application/vnd.git-lfs+json");
        return new LfsRequest((HttpUriRequest)req, null);
    }

    @Override
    @Nullable
    public ObjectRes processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) throws IOException {
        ObjectRes objectRes;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                objectRes = (ObjectRes)mapper.readValue(response.getEntity().getContent(), ObjectRes.class);
                break;
            }
            case 404: {
                objectRes = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return objectRes;
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        int[] nArray = new int[]{200, 404};
        return nArray;
    }
}

