/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.index.architecture.ArchitectureReferenceIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public class ArchitectureFindingsCleaner
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureReferenceIndex architectureReferenceIndex;

    public void execute() throws StorageException {
        List deletedContentKeys = this.contentDelta.getDeletedKeysAsStrings();
        if (deletedContentKeys.isEmpty()) {
            return;
        }
        List<String> partitions = this.architectureReferenceIndex.getAllArchitectures();
        for (String partition : partitions) {
            this.findingsIndex.removeFindingsForPartitionsAndPaths(partition, deletedContentKeys);
        }
    }
}

