/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.http;

import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.ReadCachedBackupTargetBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class HttpBackupTarget
extends ReadCachedBackupTargetBase {
    private final URI uri;

    public HttpBackupTarget(URI uri) {
        this.uri = uri;
    }

    @Override
    public String validate() {
        try {
            this.uri.toURL();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("It is not possible to write to a HTTP URL.");
    }

    @Override
    protected void writeToTemporaryFile(File temporaryFile) throws IOException {
        try (InputStream inputStream = this.uri.toURL().openStream();
             FileOutputStream outputStream = new FileOutputStream(temporaryFile);){
            FileSystemUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public void deleteBackupFile() {
    }

    @Override
    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo backupLocationInfo) {
        return Collections.emptyList();
    }

    @Override
    public void deleteBackupsInSameLocation(List<BackupInfo> backupInfos) {
    }
}

