/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.write;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.backup.write.EBackupExportExcludeOptions;
import com.teamscale.index.backup.write.ExternalUploadExportOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class BackupExportOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="exportGlobalData")
    private boolean exportGlobalData = false;
    @JsonProperty(value="includeAllProjects")
    private boolean includeAllProjects = false;
    @JsonProperty(value="includedProjects")
    private final Set<PublicProjectId> includedProjects = new HashSet<PublicProjectId>();
    @JsonProperty(value="useLocalCryptoKey")
    private boolean useLocalCryptoKey = false;
    @JsonProperty(value="backupTarget")
    private String backupTarget;
    @JsonProperty(value="exportExcludeOptions")
    private Set<EBackupExportExcludeOptions> exportExcludeOptions = new HashSet<EBackupExportExcludeOptions>();
    @JsonProperty(value="externalUploadExportOptions")
    private final List<ExternalUploadExportOption> externalUploadExportOptions = new ArrayList<ExternalUploadExportOption>();

    public boolean isExportGlobalData() {
        return this.exportGlobalData;
    }

    public boolean isProjectIncluded(PublicProjectId project) {
        return this.includeAllProjects || this.includedProjects.contains(project);
    }

    public String getBackupTarget() {
        return this.backupTarget;
    }

    public BackupExportOptions setExportGlobalData(boolean value) {
        this.exportGlobalData = value;
        return this;
    }

    public BackupExportOptions setIncludeAllProjects(boolean value) {
        this.includeAllProjects = value;
        return this;
    }

    public BackupExportOptions addIncludedProject(PublicProjectId id) {
        this.includedProjects.add(id);
        return this;
    }

    public Set<PublicProjectId> getAllIncludedProjects() {
        return CollectionUtils.asUnmodifiable(this.includedProjects);
    }

    public Set<EBackupExportExcludeOptions> getExportExcludeOptions() {
        return this.exportExcludeOptions;
    }

    public void setExportExcludeOptions(Set<EBackupExportExcludeOptions> exportExcludeOptions) {
        this.exportExcludeOptions = exportExcludeOptions;
    }

    public BackupExportOptions setBackupTarget(String backupTarget) {
        this.backupTarget = backupTarget;
        return this;
    }

    public Optional<PublicProjectId> getSingleProjectId() {
        if (this.isExportGlobalData() || this.includeAllProjects || this.includedProjects.size() != 1) {
            return Optional.empty();
        }
        return Optional.of((PublicProjectId)CollectionUtils.getAny(this.includedProjects));
    }

    public List<ExternalUploadExportOption> getExternalUploadExportOptions() {
        return this.externalUploadExportOptions;
    }

    public void addExternalUploadExportOption(ExternalUploadExportOption rule) {
        this.externalUploadExportOptions.add(rule);
    }
}

