/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IMountableStorageIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Index(name="x-finding-blacklist", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.CROSS_PROJECT_MOUNTABLE}, valueClasses={FindingBlacklistInfo.class})
public class BranchAgnosticFindingBlacklistIndex
extends IndexBase
implements IProjectIndex,
IMountableStorageIndex {
    public static final String INDEX_NAME = "x-finding-blacklist";

    public BranchAgnosticFindingBlacklistIndex(IStore store) {
        super(store);
    }

    public void setIfNewer(FindingBlacklistInfo blacklistInfo) throws StorageException {
        FindingBlacklistInfo existingInfo = this.getExistingBlacklistInfo(blacklistInfo.getFindingId());
        if (existingInfo == null || existingInfo.getTimestamp() < blacklistInfo.getTimestamp()) {
            this.store.putWithString(blacklistInfo.getFindingId(), StorageUtils.serialize((Serializable)blacklistInfo));
        }
    }

    public void removeIfNewer(String findingId, long timestamp) throws StorageException {
        FindingBlacklistInfo existingInfo = this.getExistingBlacklistInfo(findingId);
        if (existingInfo == null || existingInfo.getTimestamp() < timestamp) {
            this.store.removeWithString(findingId);
        }
    }

    private FindingBlacklistInfo getExistingBlacklistInfo(String findingId) throws StorageException {
        return (FindingBlacklistInfo)StorageUtils.deserialize((byte[])this.store.getWithString(findingId));
    }

    public List<FindingBlacklistInfo> getExistingBlacklistInfos(List<String> findingIds) throws StorageException {
        return StorageUtils.deserializeValues((List)this.store.getWithStrings(findingIds));
    }

    public List<FindingBlacklistInfo> getAllExistingBlacklistInfos() throws StorageException {
        return StorageUtils.deserializeValues((List)this.store.getEntriesStartingWith("").getSecondList());
    }

    public Lock obtainStoreLock(String suffix) {
        return this.store.obtainLock(suffix);
    }
}

