/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.base.MergeCommitAnalysisStepBase;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class FindingsBlacklistMerger
extends MergeCommitAnalysisStepBase {
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<FindingBlacklistIndex> parentFindingBlacklistIndices;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistIndex findingBlacklistIndex;

    private static FindingBlacklistInfo merge(FindingBlacklistInfo oldValue, FindingBlacklistInfo newValue) {
        if (newValue.getTimestamp() > oldValue.getTimestamp()) {
            return newValue;
        }
        return oldValue;
    }

    @Override
    protected void processMergeCommit() throws StorageException {
        Preconditions.checkState((this.parentFindingBlacklistIndices.size() > 1 ? 1 : 0) != 0, (Object)"Expecting more than to parent indexes for merge commit.");
        PairList allEntries = new PairList();
        for (int i = 1; i < this.parentFindingBlacklistIndices.size(); ++i) {
            FindingBlacklistIndex blacklistIndex = this.parentFindingBlacklistIndices.get(i);
            blacklistIndex.getAllBlacklistInfos().forEach((arg_0, arg_1) -> ((PairList)allEntries).add(arg_0, arg_1));
        }
        this.findingBlacklistIndex.setOrMergeBlacklistEntries((PairList<String, FindingBlacklistInfo>)allEntries, FindingsBlacklistMerger::merge);
    }
}

